/*
 * Decompiled with CFR 0.152.
 */
package Model;

import java.text.DecimalFormat;

public class Model {
    private static final DecimalFormat four = new DecimalFormat("#0.00");
    private int sno;
    private String geneName;
    private int geneSequenceSize;
    private int noOfNonSynonymousChange;
    private int noOfSynonymousChange;
    private String avgOfSynonymousChange;
    private String avgOfNonSynonymousChange;
    private String dn;
    private String ds;
    private String dnbyds;

    public Model() {
    }

    public Model(int sno, String geneName, int geneSequenceSize, int noOfSynonymousChange, int noOfNonSynonymousChange, Double avgOfSynonymousChange, Double avgOfNonSynonymousChange) {
        this.sno = sno;
        this.geneName = geneName.substring(1);
        this.geneSequenceSize = geneSequenceSize;
        this.noOfNonSynonymousChange = noOfNonSynonymousChange;
        this.noOfSynonymousChange = noOfSynonymousChange;
        this.avgOfSynonymousChange = four.format(avgOfSynonymousChange);
        this.avgOfNonSynonymousChange = four.format(avgOfNonSynonymousChange);
        double ps = (double)noOfSynonymousChange / avgOfSynonymousChange;
        double pn = (double)noOfNonSynonymousChange / avgOfNonSynonymousChange;
        double ds = -0.75 * Math.log(1.0 - 1.3333333333333333 * ps);
        double dn = -0.75 * Math.log(1.0 - 1.3333333333333333 * pn);
        this.dn = four.format(dn);
        this.ds = four.format(ds);
        this.dnbyds = ds == 0.0 ? "NA" : four.format(dn / ds);
    }

    public String toString() {
        return this.geneName + ", " + this.geneSequenceSize + ", " + this.noOfSynonymousChange + ", " + this.noOfNonSynonymousChange + ", " + this.avgOfSynonymousChange + ", " + this.avgOfNonSynonymousChange;
    }

    public Object[] getModel() {
        return new Object[]{this.sno, this.geneName, this.geneSequenceSize, this.noOfSynonymousChange, this.noOfNonSynonymousChange, this.avgOfSynonymousChange, this.avgOfNonSynonymousChange, this.dn, this.ds, this.dnbyds};
    }
}

