/*
 * Decompiled with CFR 0.152.
 */
package View;

import Model.InputModel;
import Model.Model;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class Home {
    JFrame f;
    JTable j;

    Home(File a, File b) throws IOException {
        InputModel model = new InputModel();
        model.input(a, b);
        model.calculate();
        List<Model> result = model.result;
        this.f = new JFrame();
        this.f.setTitle("Bioinformatics Toolkit");
        Object[][] data = new Object[result.size()][7];
        int idx = 0;
        for (Model m : result) {
            data[idx] = m.getModel();
            ++idx;
        }
        Object[] columnNames = new String[]{"S.No", "Gene Name", "Gene Sequence Length", "Synonymous Change", "Non Synonymous Change", "Synonymous Sites", "Non Synonymous Sites", "dn", "ds", "dn/ds"};
        this.j = new JTable(data, columnNames);
        this.j.setFont(new Font("Arial", 0, 14));
        this.j.setRowHeight(25);
        this.j.getTableHeader().setFont(new Font("Arial", 1, 15));
        this.j.setBackground(new Color(235, 235, 235));
        this.j.setBounds(100, 60, 200, 300);
        JScrollPane sp = new JScrollPane(this.j);
        this.f.add(sp);
        this.f.setExtendedState(6);
        this.f.setVisible(true);
    }

    public static boolean exportToCSV(JTable tableToExport, String pathToExportTo) {
        try {
            int i;
            TableModel model = tableToExport.getModel();
            FileWriter csv = new FileWriter(new File(pathToExportTo));
            for (i = 0; i < model.getColumnCount(); ++i) {
                csv.write(model.getColumnName(i) + ",");
            }
            csv.write("\n");
            for (i = 0; i < model.getRowCount(); ++i) {
                for (int j = 0; j < model.getColumnCount(); ++j) {
                    csv.write(model.getValueAt(i, j).toString() + ",");
                }
                csv.write("\n");
            }
            csv.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

